<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vague extends Model 
{

    protected $table = 'vagues';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'libelle', 'id_espece', 'effectif', 'effectiDepart', 'statut', 'description');
    protected $visible = array('slug', 'libelle', 'id_espece', 'effectif', 'effectiDepart', 'statut', 'description');

    public function espece()
    {
        return $this->belongsTo('App\Models\Espece', 'id_espece');
    }

    public function mouvementEffectif()
    {
        return $this->hasMany('App\Models\MouvementEffectif', 'id_vague');
    }

    public function alimentVague()
    {
        return $this->hasMany('App\Models\AlimentVague', 'id_vague');
    }

    public function depense()
    {
        return $this->hasMany('App\Models\Depense', 'id_vague');
    }

    public function passageVeterinaireVague()
    {
        return $this->hasMany('App\Models\PassageVeterinaireVague', 'id_vague');
    }

}